/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class UnlimitedHours
extends Hours {
    private static final long serialVersionUID = 6368054767763408389L;
    public static final String UNIT_KEY = "dialog.timeParameter.unlimitedHours";
    public static final String DEFAULT_UNIT_STRING = "unlimitedHours";

    public UnlimitedHours(int highMax) {
        this.fHighMax = highMax;
    }

    public UnlimitedHours() {
    }

    public TimeUnit setTime(int value) {
        int rangedValue = Util.getValueInRange(0, this.fHighMax * 60 + 59, value);
        this.setTime(rangedValue / 60, rangedValue % 60);
        return this;
    }

    public String getUnitKey() {
        return "dialog.timeParameter.unlimitedHours." + this.fHighMax;
    }

    public String getDefaultUnitString() {
        return DEFAULT_UNIT_STRING;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
    }

    public int[] getLogoTime() {
        long time = (long)this.getHighValue() * 60L + (long)this.getLowValue();
        int[] lTime = new int[]{(int)((time & 0xFFFFFFFFFF000000L) >> 24) & 0x3F, (int)((time & 0xFF0000L) >> 16), (int)((time & 0xFF00L) >> 8), (int)(time & 0xFFL)};
        return lTime;
    }

    public int getReferencedValue() {
        long time = (long)this.getHighValue() * 60L + (long)this.getLowValue();
        if (time > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (time < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)time;
    }

    public String getTimeAsString() {
        if (this.getHighValue() < 0 || this.getLowValue() < 0) {
            return "Error ";
        }
        String high = String.valueOf(this.getHighValue());
        String low = String.valueOf(this.getLowValue());
        high = this.getSpaceBars().substring(high.length()) + high;
        if (low.length() < 2) {
            low = " " + low;
        }
        return high + "h" + low + "m";
    }

    public String getTimeAsStringLong() {
        String high = String.valueOf(this.getHighValue());
        String low = String.valueOf(this.getLowValue());
        high = this.getSpaceBars().substring(high.length()) + high;
        return high + ":" + low + " " + Language.getString(super.getUnitKey(), super.getDefaultUnitString());
    }

    private String getSpaceBars() {
        return "                  ".substring(0, String.valueOf(this.fHighMax).length());
    }

    public String extendToSameLength(String preStr) {
        if (preStr != null && preStr.length() <= 8) {
            return "         ".substring(preStr.length()) + preStr;
        }
        return preStr;
    }
}

